DROP INDEX IX_PFSAL_PorId_Familia ON Prod_Familias_Salas
GO

CREATE INDEX [IX_PFSAL_PorId_Familia] ON [dbo].[Prod_Familias_Salas]
(
	[Id_Familia] ASC,
	[Edad_Min] ASC,
	[Edad_Max] ASC,
	[Sexo] ASC
)
GO


SET IDENTITY_INSERT Prod_Familias_Salas ON
GO
DECLARE @Max INT
SET @Max = ISNULL((SELECT MAX(Id_Prod_Familia_Sala) FROM Prod_Familias_Salas),0) 

DBCC CHECKIDENT (Prod_Familias_Salas, reseed, @Max)
GO

IF NOT EXISTS (SELECT 1 FROM Prod_Familias_Salas WHERE Id_Prod_Familia_Sala = 0)
BEGIN
   INSERT INTO Prod_Familias_Salas (Id_Prod_Familia_Sala, Activo, Id_Familia, Descripcion) VALUES (0,0,0,'NO DEFINIDO')
END

SET IDENTITY_INSERT Prod_Familias_Salas OFF
GO



